#ifndef _MMATERIAL_H_
#define _MMATERIAL_H_

enum
{
	ID_MATERIALGROUP_COLOR 					= 807,
	ID_MATERIALGROUP_DIFFUSION			= 808,
	ID_MATERIALGROUP_LUMINANCE			= 809,
	ID_MATERIALGROUP_TRANSPARENCY		= 810,
	ID_MATERIALGROUP_REFLECTION			= 811,
	ID_MATERIALGROUP_ENVIRONMENT		= 812,
	ID_MATERIALGROUP_FOG						= 813,
	ID_MATERIALGROUP_BUMP				  	= 814,
	ID_MATERIALGROUP_ALPHA					= 815,
	ID_MATERIALGROUP_SPECULAR				= 816,
	ID_MATERIALGROUP_SPECULARCOLOR	= 817,
	ID_MATERIALGROUP_GLOW					  = 818,
	ID_MATERIALGROUP_DISPLACEMENT		= 819,

	MATERIAL_USE_COLOR 										= 2000,
	MATERIAL_USE_DIFFUSION								= 2001,
	MATERIAL_USE_LUMINANCE								= 2002,
	MATERIAL_USE_TRANSPARENCY							= 2003,
	MATERIAL_USE_REFLECTION								= 2004,
	MATERIAL_USE_ENVIRONMENT							= 2005,
	MATERIAL_USE_FOG											= 2006,
	MATERIAL_USE_BUMP											= 2007,
	MATERIAL_USE_ALPHA										= 2008,
	MATERIAL_USE_SPECULAR									= 2009,
	MATERIAL_USE_SPECULARCOLOR						= 2010,
	MATERIAL_USE_GLOW											= 2011,
	MATERIAL_USE_DISPLACEMENT							= 2012,

	MATERIAL_COLOR_COLOR 									= 2100,
	MATERIAL_COLOR_BRIGHTNESS 						= 2101,
	MATERIAL_COLOR_TEXTURESTRENGTH				= 2102,
	MATERIAL_COLOR_TEXTUREMIXING					= 2103,
		MATERIAL_TEXTUREMIXING_NORMAL						= 0,
		MATERIAL_TEXTUREMIXING_ADD							= 1,
		MATERIAL_TEXTUREMIXING_SUBTRACT					= 2,
		MATERIAL_TEXTUREMIXING_MULTIPLY					= 3,

	MATERIAL_DIFFUSION_BRIGHTNESS 				= 2200,
	MATERIAL_DIFFUSION_TEXTURESTRENGTH		= 2201,
	MATERIAL_DIFFUSION_TEXTUREMIXING			= 2202,
	MATERIAL_DIFFUSION_AFFECT_LUMINANCE 	= 1002,
	MATERIAL_DIFFUSION_AFFECT_SPECULAR 		= 1000,
	MATERIAL_DIFFUSION_AFFECT_REFLECTION	= 1001,

	MATERIAL_LUMINANCE_COLOR 							= 2300,
	MATERIAL_LUMINANCE_BRIGHTNESS 				= 2301,
	MATERIAL_LUMINANCE_TEXTURESTRENGTH		= 2302,
	MATERIAL_LUMINANCE_TEXTUREMIXING			= 2303,

	MATERIAL_TRANSPARENCY_COLOR 					= 2400,
	MATERIAL_TRANSPARENCY_BRIGHTNESS 			= 2401,
	MATERIAL_TRANSPARENCY_TEXTURESTRENGTH	= 2402,
	MATERIAL_TRANSPARENCY_TEXTUREMIXING		= 2403,
	MATERIAL_TRANSPARENCY_REFRACTION 			= 1005,
	MATERIAL_TRANSPARENCY_FRESNEL 				= 1003,
	MATERIAL_TRANSPARENCY_ADDITIVE 				= 1004,

	MATERIAL_TRANSPARENCY_DISPERSION 			= 1120,
	MATERIAL_TRANSPARENCY_MINSAMPLES 			= 1122,
	MATERIAL_TRANSPARENCY_MAXSAMPLES 			= 1123,
	MATERIAL_TRANSPARENCY_ACCURACY   			= 1121,

	MATERIAL_REFLECTION_COLOR 						= 2500,
	MATERIAL_REFLECTION_BRIGHTNESS 				= 2501,
	MATERIAL_REFLECTION_TEXTURESTRENGTH		= 2502,
	MATERIAL_REFLECTION_TEXTUREMIXING			= 2503,

	MATERIAL_REFLECTION_DISPERSION 				= 1130,
	MATERIAL_REFLECTION_MINSAMPLES 				= 1132,
	MATERIAL_REFLECTION_MAXSAMPLES 				= 1133,
	MATERIAL_REFLECTION_ACCURACY  				= 1131,

	MATERIAL_ENVIRONMENT_COLOR						= 2600,
	MATERIAL_ENVIRONMENT_BRIGHTNESS				= 2601,
	MATERIAL_ENVIRONMENT_TEXTURESTRENGTH	= 2602,
	MATERIAL_ENVIRONMENT_TEXTUREMIXING		= 2603,
	MATERIAL_ENVIRONMENT_TILESX						= 1006,
	MATERIAL_ENVIRONMENT_TILESY						= 1007,
	MATERIAL_ENVIRONMENT_EXCLUSIVE				= 1028,

	MATERIAL_FOG_COLOR										= 2700,
	MATERIAL_FOG_BRIGHTNESS								= 2701,
	MATERIAL_FOG_DISTANCE									= 1008,

	MATERIAL_BUMP_STRENGTH								= 1009,
	MATERIAL_BUMP_MIPFALLOFF							= 1010,

	MATERIAL_ALPHA_COLOR									= 2900,
	MATERIAL_ALPHA_DELTA									= 1011,
	MATERIAL_ALPHA_INVERT									= 1014,
	MATERIAL_ALPHA_SOFT										= 1012,
	MATERIAL_ALPHA_IMAGEALPHA							= 1013,
	MATERIAL_ALPHA_PREMULTIPLIED					= 1027,

	MATERIAL_SPECULAR_MODE								= 1018,
		MATERIAL_SPECULAR_MODE_PLASTIC				= 0,
		MATERIAL_SPECULAR_MODE_METAL 					= 1,
		MATERIAL_SPECULAR_MODE_COLORED				= 2,
	MATERIAL_SPECULAR_WIDTH								= 1016,
	MATERIAL_SPECULAR_HEIGHT							= 1017,
	MATERIAL_SPECULAR_FALLOFF							= 1137,
	MATERIAL_SPECULAR_INNERWIDTH					= 1139,

	MATERIAL_SPECULAR_COLOR								= 3100,
	MATERIAL_SPECULAR_BRIGHTNESS					= 3101,
	MATERIAL_SPECULAR_TEXTURESTRENGTH			= 3102,
	MATERIAL_SPECULAR_TEXTUREMIXING				= 3103,

	MATERIAL_GLOW_COLOR										= 3200,
	MATERIAL_GLOW_BRIGHTNESS							= 3201,
	MATERIAL_GLOW_INNERSTRENGTH						= 1019,
	MATERIAL_GLOW_OUTERSTRENGTH						= 1020,
	MATERIAL_GLOW_RADIUS									= 1021,
	MATERIAL_GLOW_RANDOM									= 1022,
	MATERIAL_GLOW_FREQUENCY								= 1023,
	MATERIAL_GLOW_USEMATERIALCOLOR				= 1024,

	MATERIAL_DISPLACEMENT_STRENGTH				= 1025,
	MATERIAL_DISPLACEMENT_HEIGHT					= 1026,

	MATERIAL_ILLUMINATION_MODEL						= 1134,
		MATERIAL_ILLUMINATION_MODEL_PHONG			= 0,
		MATERIAL_ILLUMINATION_MODEL_BLINN			= 1,
		MATERIAL_ILLUMINATION_MODEL_ORENNAYAR	= 2,
	MATERIAL_ILLUMINATION_DIFFUSEFALLOFF	= 1136,
	MATERIAL_ILLUMINATION_DIFFUSELEVEL		= 1138,
	MATERIAL_ILLUMINATION_ROUGHNESS				= 1135,

	//MATERIAL_GLOBALILLUM_GENERATE					= 1101,
	//MATERIAL_GLOBALILLUM_GENERATE_STRENGTH= 1112,
	//MATERIAL_GLOBALILLUM_RECEIVE					= 1100,
	//MATERIAL_GLOBALILLUM_RECEIVE_STRENGTH	= 1102,
	//MATERIAL_GLOBALILLUM_SATURATION				= 1115,

	//MATERIAL_CAUSTICS_GENERATE						= 1109,
	//MATERIAL_CAUSTICS_GENERATE_STRENGTH		= 1113,
	//MATERIAL_CAUSTICS_RECEIVE							= 1108,
	//MATERIAL_CAUSTICS_RECEIVE_STRENGTH		= 1114,
	//MATERIAL_CAUSTICS_SAMPLERADIUS				= 1110,
	//MATERIAL_CAUSTICS_SAMPLES							= 1111,

	MATERIAL_PREVIEWSIZE									= 500,
		MATERIAL_PREVIEWSIZE_DEF							= 0,
		MATERIAL_PREVIEWSIZE_64								= 6,
		MATERIAL_PREVIEWSIZE_128							= 7,
		MATERIAL_PREVIEWSIZE_256							= 8,
		MATERIAL_PREVIEWSIZE_512							= 9,
		MATERIAL_PREVIEWSIZE_1024							= 10,
		MATERIAL_PREVIEWSIZE_2048							= 11,

	// virtual IDs
	MATERIAL_COLOR_TEXGROUP								= 8000,
	MATERIAL_DIFFUSION_TEXGROUP						= 8001,
	MATERIAL_LUMINANCE_TEXGROUP						= 8002,
	MATERIAL_TRANSPARENCY_TEXGROUP				= 8003,
	MATERIAL_REFLECTION_TEXGROUP					= 8004,
	MATERIAL_ENVIRONMENT_TEXGROUP					= 8005,
	MATERIAL_BUMP_TEXGROUP								= 8006,
	MATERIAL_ALPHA_TEXGROUP								= 8007,
	MATERIAL_SPECULAR_TEXGROUP						= 8008,
	MATERIAL_DISPLACEMENT_TEXGROUP				= 8009,
	MATERIAL_SPECULARPREVIEW							= 8010
};

#endif